import pickle
import json

import matplotlib.pyplot as plt
from collections import defaultdict

import json

with open('./NEW_description_and_query.json', 'r') as fp:
    data = json.load(fp)
print('da')

def plot_label_distribution(label_dict, all_labels, title):
    label_count = defaultdict(int)

    for labels in label_dict.values():
        for label in labels:
            label_count[label] += 1

    for label in all_labels:
        if label not in label_count:
            label_count[label] = 0

    sorted_labels = sorted(label_count.items(), key=lambda x: x[1], reverse=True)
    labels, counts = zip(*sorted_labels)
    labels = [label.replace('Category-', '') for label in labels]
    plt.figure(figsize=(12, 6))
    plt.bar(labels, counts)
    plt.xlabel('name')
    plt.ylabel('number')
    plt.title(title)
    plt.xticks(rotation=45, ha='right')
    plt.tight_layout()
    plt.show()


shortcut_categories = ['Category-Weather', 'Category-Games', 'Category-Finance', 'Category-Travel', 'Category-Reference', 'Category-Widgets', 'Category-Utilities', 'Category-Medical', 'Category-Navigation', 'Category-Productivity',
              'Category-Snippets', 'Category-Sports', 'Category-Books', 'Cayegory-Social Networking', 'Category-Lifestyle', 'Category-Education', 'Category-Graphics & Design', 'Category-Shopping', 'Category-News', 'Category-Jailbreaking',
              'Category-Kids', 'Category-Entertainment', 'Category-Photo & Video', 'Category-Business', 'Category-Health & Fitness', 'Category-Music', 'Category-Development Tools', 'Category-Food & Drink']



action_categories = {
    'Other': """Various APIs that don't fall under standard categories.""",
    'Sports': """Sports APIs encompass various categories such as sports odds, top scores, NCAA, football, women's sports, and trending sports news.""",
    'Artificial Intelligence/Machine Learning': """A Machine Learning API interprets data, identifies patterns, and makes predictive decisions based on extracted information. Acting as an intermediary between user queries and predictive answers, these APIs tap into data and send solutions to applications.""",
    'Finance': """Finance APIs offer users diverse services for account management and staying informed about market events. They enable remote access to bank accounts for transactions and provide features like stock market news, trading platforms, and cryptocurrency market data.""",
    'Data': """APIs facilitate the seamless exchange of data between applications and databases, enabling developers to integrate functionalities securely and swiftly.""",
    'Entertainment': """Entertainment APIs ranging from movies and love interest research to jokes, memes, games, and music exploration.""",
    'Travel': """Travel APIs serve as the intermediary between users and vast databases, providing real-time information on hotel prices, airline itineraries, and destination recommendations.""",
    'Location': """Location APIs power applications that depend on user location for relevant results, such as Foursquare for recommendations. They're utilized by delivery services like DoorDash to determine service areas and delivery times.""",
    'Science': """Science APIs facilitate access to a plethora of scientific knowledge. With science covering a broad spectrum of topics, these APIs cater to various needs, from tracking environmental changes to providing educational resources on the periodic table.""",
    'Food': """Food APIs link users' devices to vast food-related databases, offering features like recipes, nutritional information, and even food delivery services.""",
    'Transportation': """Transportation APIs revolutionize travel by connecting users to transit system databases, offering options for air, land, and sea travel. From exploring bus routes to booking flights, trains, or boat trips, these APIs provide convenience and flexibility.""",
    'Music': """Music APIs enable developers to integrate music and its associated data into various applications and services, offering functionalities such as streaming, displaying lyrics, and providing metadata like song details and artist information.""",
    'Business': """Business APIs cover a wide range of functionalities, from e-commerce inventory management to internal operations and customer-facing interactions. These APIs provide secure access to company data, making it easily consumable and analyzable.""",
    'Visual Recognition': """Visual Recognition APIs use deep learning to identify faces, objects, text, and more in images and videos. Leveraging vast datasets, these APIs enable accurate classification, empowering developers to integrate this technology into their applications seamlessly.""",
    'Tools': """Tool APIs offer a diverse range of functionalities, from text analysis to generating QR codes and providing chatbot services. These APIs enhance efficiency for businesses and applications, catering to both internal and external needs.""",
    'Text Analysis': """Text Analysis APIs leverage AI and NLP to dissect large bodies of text, offering functionalities such as translation, fact extraction, sentiment analysis, and keyword research. Businesses and consumers can benefit from these APIs for tasks like data mining, article spinning, and sentiment analysis, enhancing various processes and decision-making capabilities.""",
    'Weather': """Weather APIs provide users with access to accurate forecasts and meteorological data, essential for planning daily activities, agricultural decisions, travel arrangements, and more. These APIs connect users to data providers that aggregate and process complex weather data into regional forecasts.""",
    'Gaming': """Gaming APIs connect users to game servers for tasks like account management, gameplay analysis, and content modification. They facilitate the development of third-party applications for altering game elements and aggregating global gaming statistics.""",
    'SMS': """SMS APIs enable businesses to send messages and updates to customers automatically, facilitating continuous communication without the need for human intervention.""",
    'Events': """Events APIs keep users informed about various events of interest, spanning holidays, sports, and corporate events.""",
    'Health and Fitness': """Health and fitness APIs offer tools for managing nutrition, exercise, and health monitoring. These APIs provide access to various functionalities, such as nutrition data from food databases, personalized exercise routines, and tracking vital statistics through wearable devices or smartphones.""",
    'Payments': """Payment APIs streamline digital transactions by enabling secure payment processing directly within applications or websites. Additionally, some payment APIs offer secondary features such as fraud detection and blocking suspicious IP addresses to enhance security measures.""",
    'Financial': """Financial APIs link users to various financial institutions and news outlets, enabling access to account information, market rates, and industry news. They facilitate trading and decision-making, enhancing efficiency in financial transactions.""",
    'Translation': """Translation APIs integrate cloud translation services into applications, eliminating the need for storing large data volumes. They facilitate text translation between applications and web pages, breaking down language barriers and expanding market reach.""",
    'Storage': """Storage APIs facilitate connectivity between local applications and third-party cloud storage services, data lakes, and data warehouses. Users can send, access, and manipulate data stored in these systems seamlessly.""",
    'Logistics': """Logistics APIs streamline the transportation process by facilitating operations like credit card processing, address validation, label printing, and order tracking.""",
    'Database': """A Database API (DB-API) facilitates communication between applications and databases, retrieving requested information stored on servers. This API acts as the intermediary connecting the two machines, enabling seamless access to various data, from song lyrics to financial details, based on user input.""",
    'Search': """Search APIs are application programming interfaces that allow developers to integrate search functionality into their applications or websites. These APIs enable users to search for specific information or content within a designated database, website, or platform.""",
    'Reward': """Reward APIs simplify the implementation of rewards and coupon systems into applications, enhancing customer loyalty efforts. They provide an up-to-date inventory of physical goods, digital coupons, and rewards, replacing cumbersome CSV format uploads.""",
    'Mapping': """Mapping APIs provide location services and intelligence to developers for various applications, from finding routes to events to planning shipping routes and offering location-based recommendations.""",
    'Email': """Email APIs enable users to access and utilize the functionalities of email service providers, facilitating tasks like generating and sending emails, automating invoice sending, and managing folders.""",
    'News, Media': """News and Media APIs are tools that allow developers to integrate news and media content into their applications, websites, or services. These APIs provide access to a wide range of news articles, multimedia content (such as images and videos), headlines, and related information from various sources.""",
    'Video, Images': """Video and Images APIs are tools that provide developers with access to various functionalities related to managing, processing, and integrating video and image content into applications, websites, or services.""",
    'eCommerce': """eCommerce APIs are application programming interfaces that provide developers with access to functionalities related to online commerce and retail. These APIs enable developers to integrate eCommerce features into their applications, websites, or services, allowing businesses to sell products and services online.""",
    'Medical': """Medical APIs are crucial online resources providing access to valuable medical information for patients, doctors, and pharmacists. They centralize data on drug interactions, disease symptoms, and treatments, allowing websites and apps to share information.""",
    'Devices': """Device APIs enable seamless interaction between internet-connected devices and software applications, empowering functionalities like home and industrial automation. They bridge hardware and software, facilitating remote control and enhancing user experiences.""",
    'Business Software': """Business software APIs streamline communication between different business applications, improving efficiency and productivity across various programs and applications.""",
    'Advertising': """Advertising APIs streamline campaign management by integrating with advertising platforms. They also support functions like customer outreach, competitor SEO analysis, and campaign optimization through analytics.""",
    'Education': """Education APIs facilitate seamless access to educational resources, connecting databases of institutions with students and researchers. They power online classes, enable instant access to grades and assignments, and enhance research capabilities.""",
    'Media': """Media APIs provide access to vast databases of articles, videos, music, or images, enabling users to view, download, extract information, interact with, or manipulate the content to enhance their media consumption experience.""",
    'Social': """Social APIs enable developers to integrate social media platforms into their applications, allowing for connectivity and access to platform databases for analytical or manipulation purposes.""",
    'Commerce': """A Commerce API facilitates online commerce activities for businesses or entities, offering various functionalities like researching past buying behaviors, accessing tax rates, verifying user information, and analyzing trending topics for product offerings.""",
    'Communication': """A Communication API enables developers to integrate text messaging, voice calling, and other communication functionalities into their applications or for businesses. These APIs include voice, SMS, MMS, RCS, chat, and emergency calling.""",
    'Monitoring': """A Monitoring API enables applications to access data for tracking various activities, from monitoring competitors' websites to tracking COVID statistics.""",
    'Energy': """Energy APIs connect applications to data sources for tracking, statistical analysis, and monitoring of energy consumption. They serve as the bridge between applications and energy company servers, facilitating greener energy management.""",
    'Jobs': """Jobs APIs are application programming interfaces that provide access to job-related data, such as job listings, career opportunities, company profiles, and employment statistics.""",
    'Movies': """Movie APIs connect applications or websites to servers housing movie-related information or files, enabling users to access various movie-related data and functionalities.""",
    'Cryptography': """Cryptography APIs offer developers tools for implementing encryption, decryption, hashing, digital signatures, and secure communication protocols in their applications, ensuring data security and integrity.""",
    'Cybersecurity': """Cybersecurity APIs offer tools for developers to bolster the security of their applications and systems, including threat detection, authentication, encryption, and access control, guarding against cyber threats and attacks."""
}


with open('./identifier2category.pkl', 'rb') as fp:
    identifier2category = pickle.load(fp)

plot_label_distribution(identifier2category, list(action_categories.keys()), title="action distribution" )


with open('./Routinehub_shortcut2category.pkl', 'rb') as fp:
    gold_shortcut2category = pickle.load(fp)
plot_label_distribution(gold_shortcut2category, shortcut_categories, title="gold shorcut distribution" )


with open('./deberta_predicted_query_and_description.json', 'r') as fp:
    ALL_shortcut2category = json.load(fp)
    ALL_shortcut2category = {_['key']:_['label'] for _ in ALL_shortcut2category}
plot_label_distribution(ALL_shortcut2category, shortcut_categories, title="ALL shorcut distribution" )

